/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.util;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.BlockIfcFigure;
import DE.siemens.ad.pdraw.figures.CommentTextFigure;
import DE.siemens.ad.pdraw.figures.CutConnectFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.InputCutConnectFigure;
import DE.siemens.ad.pdraw.figures.OutputCutConnectFigure;
import DE.siemens.ad.pdraw.figures.constraints.CuttedConnectionConstraint;
import DE.siemens.ad.pdraw.figures.constraints.InputLineConstraint;
import DE.siemens.ad.pdraw.figures.constraints.OutputLineConstraint;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.udf.EditUDFFigure;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockFigure;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.Element;

public class LayoutProducerXMLUDF {
    private DrawingView fView;
    private WiringDiagram fWD;
    private Document fDocument;
    private Element fFiguresNode;
    private Hashtable<String, CutConnectFigure> fCuttedFigureStorer = new Hashtable();

    public LayoutProducerXMLUDF(DrawingView view, Document document) {
        this.fView = view;
        this.fWD = ((LogoDrawing)this.fView.drawing()).getWiringDiagram();
        this.fDocument = document;
        this.fFiguresNode = (Element)this.fDocument.selectSingleNode("/LOGO/Figures");
        Element propertiesNode = (Element)this.fDocument.selectSingleNode("/LOGO/Properties");
        Element zoomNode = propertiesNode.element("Zoom");
        ((LogoDrawingView)this.fView).getZoomManager().setZoom(Integer.valueOf(zoomNode.getText()));
        ((LogoDrawing)view.drawing()).setPageFormat(this.loadPageFormat(propertiesNode));
    }

    public void layout() {
        Element figureNode = null;
        Iterator figureIT = this.fFiguresNode.elementIterator();
        while (figureIT.hasNext()) {
            CommentTextFigure figure;
            figureNode = (Element)figureIT.next();
            String type = figureNode.attributeValue("type");
            if (type.equals("0")) {
                this.loadUDFFigure(figureNode);
                continue;
            }
            if (type.equals("1")) {
                this.loadBlockFigure(figureNode);
                continue;
            }
            if (type.equals("2")) {
                this.loadLineFigure(figureNode);
                continue;
            }
            if (type.equals("5")) {
                figure = ((LogoDrawingUDF)this.fView.drawing()).getUDFCommentTextFigure();
                this.loadCommentFigure(figure, figureNode);
                continue;
            }
            if (type.equals("3")) {
                figure = new CommentTextFigure();
                this.fView.add(figure);
                this.loadCommentFigure(figure, figureNode);
                continue;
            }
            if (!type.equals("4")) continue;
            this.loadCuttedFigure(figureNode);
        }
        this.setDescription();
        this.fCuttedFigureStorer = null;
    }

    protected Point parsePoint(String pointString) {
        Point ret = null;
        StringTokenizer sT = new StringTokenizer(pointString, ",");
        try {
            ret = new Point(Integer.valueOf(sT.nextElement().toString()), Integer.valueOf(sT.nextElement().toString()));
        }
        catch (Exception e) {
            ret = new Point(0, 0);
        }
        return ret;
    }

    protected Rectangle parseRectangle(String pointString) {
        Rectangle ret = null;
        StringTokenizer sT = new StringTokenizer(pointString, ",");
        try {
            int pointX = Integer.valueOf(sT.nextElement().toString());
            int pointY = Integer.valueOf(sT.nextElement().toString());
            Dimension d = new Dimension();
            d.setSize(Double.valueOf(sT.nextElement().toString()), Double.valueOf(sT.nextElement().toString()));
            ret = new Rectangle(new Point(pointX, pointY), d);
        }
        catch (Exception e) {
            ret = new Rectangle();
        }
        return ret;
    }

    protected void connect(Element figureNode, FixedElbowConnection connection) {
        Iterator connectorIT = figureNode.elementIterator("Connector");
        Element startElement = (Element)connectorIT.next();
        Element endElement = (Element)connectorIT.next();
        Connector startConor = startElement.attributeValue("type").equals("1") ? this.getCuttedConnector(true, startElement, connection) : this.getBlockConnector(startElement);
        Connector endConor = endElement.attributeValue("type").equals("1") ? this.getCuttedConnector(false, endElement, connection) : this.getBlockConnector(endElement);
        connection.connectStart(startConor);
        connection.connectEnd(endConor);
    }

    protected void updateIOFigurePosition(Element ioNode) {
        Block block = this.fWD.getBlock(Integer.valueOf(ioNode.attributeValue("opcode")), Integer.valueOf(ioNode.attributeValue("blockNumber")));
        BlockFigure blockFigure = this.getBlockFigure(block);
        blockFigure.moveTo(this.parsePoint(ioNode.attributeValue("position")));
    }

    protected Connector getBlockConnector(Element connectorElement) {
        Block block = this.fWD.getBlock(Integer.valueOf(connectorElement.attributeValue("opcode")), Integer.valueOf(connectorElement.attributeValue("blockNumber")));
        BlockFigure blockFigure = this.getBlockFigure(block);
        int index = Integer.valueOf(connectorElement.attributeValue("index"));
        BlockIfcFigure ifcFigure = connectorElement.attributeValue("direction").equals("0") ? (BlockIfcFigure)blockFigure.getOutputIfcFigures().get(index) : (BlockIfcFigure)blockFigure.getInputIfcFigures().get(index);
        return ifcFigure.connectorAt(0, 0);
    }

    protected CutConnectFigure getCuttedConnFigure(boolean start, String hashcode) {
        CutConnectFigure ret = this.fCuttedFigureStorer.get(hashcode);
        if (ret == null) {
            ret = start ? new OutputCutConnectFigure(new Point(0, 0)) : new InputCutConnectFigure(new Point(0, 0));
            this.fCuttedFigureStorer.put(hashcode, ret);
            this.fView.add(ret);
        }
        return ret;
    }

    protected Connector getCuttedConnector(boolean start, Element connectorElement, FixedElbowConnection connection) {
        CutConnectFigure figure = this.getCuttedConnFigure(start, connectorElement.attributeValue("identifier"));
        CutConnectFigure partner = this.getCuttedConnFigure(!start, connectorElement.attributeValue("partner"));
        figure.setPartner(partner);
        partner.setPartner(figure);
        if (start) {
            connection.setConstraint(new InputLineConstraint(connection));
        } else {
            connection.setConstraint(new OutputLineConstraint(connection));
        }
        if (figure.getConstraint().getContainer() != null) {
            CuttedConnectionConstraint cuttedConnectionConstraint = (CuttedConnectionConstraint)figure.getConstraint().getContainer();
            connection.getConstraint().setContainer(figure.getConstraint().getContainer());
        } else {
            CuttedConnectionConstraint cuttedConnectionConstraint = new CuttedConnectionConstraint();
            connection.getConstraint().setContainer(cuttedConnectionConstraint);
            figure.getConstraint().setContainer(cuttedConnectionConstraint);
            partner.getConstraint().setContainer(cuttedConnectionConstraint);
        }
        Point location = figure.displayBox().getLocation();
        return figure.connectorAt(location.x, location.y);
    }

    protected BlockFigure getBlockFigure(Block block) {
        BlockFigure ret = ((LogoDrawing)this.fView.drawing()).getBlockFigure(block);
        if (ret == null) {
            if (block.getClass() == InputBlock.class || block.getClass() == AnalogInputBlock.class || block.getClass() == OutputBlock.class || block.getClass() == AnalogOutputBlock.class) {
                EditUDFFigure editUDFFigure = ((LogoDrawingUDF)this.fView.drawing()).getEditUDFFigure();
                ret = editUDFFigure.getMiniBlockFigure(block);
                if (ret == null) {
                    EditUDFFigure editUDFFigure2 = editUDFFigure;
                    editUDFFigure2.getClass();
                    ret = new EditUDFFigure.MiniBlockFigure(editUDFFigure2, block, new Point());
                    if (block.getClass() == InputBlock.class || block.getClass() == AnalogInputBlock.class) {
                        editUDFFigure.getInputfigures().add(ret);
                    } else {
                        editUDFFigure.getOutputfigures().add(ret);
                    }
                    editUDFFigure.add(ret);
                }
            } else if (block.getClass() == UDFBlock.class) {
                ret = new UDFBlockFigure((UDFBlock)block, new Point());
                this.fView.add(ret);
            } else {
                ret = new BlockFigure(block, new Point());
                this.fView.add(ret);
            }
        }
        return ret;
    }

    protected void loadBlockFigure(Element figureNode) {
        Block block = this.fWD.getBlock(Integer.valueOf(figureNode.attributeValue("opcode")), Integer.valueOf(figureNode.attributeValue("blockNumber")));
        Point point = this.parsePoint(figureNode.attributeValue("position"));
        this.getBlockFigure(block).moveTo(point);
    }

    protected void loadUDFFigure(Element figureNode) {
        ((LogoDrawingUDF)this.fView.drawing()).getEditUDFFigure().setEditArea(this.parseRectangle(figureNode.attributeValue("area")));
        Iterator inputIT = figureNode.element("InGroup").elementIterator();
        while (inputIT.hasNext()) {
            this.updateIOFigurePosition((Element)inputIT.next());
        }
        Iterator outputIT = figureNode.element("OutGroup").elementIterator();
        while (outputIT.hasNext()) {
            this.updateIOFigurePosition((Element)outputIT.next());
        }
    }

    protected void loadLineFigure(Element figureNode) {
        FixedElbowConnection connection = new FixedElbowConnection();
        Iterator it = figureNode.element("Points").elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            connection.addPoint(Integer.valueOf(element.attributeValue("x")), Integer.valueOf(element.attributeValue("y")));
        }
        this.connect(figureNode, connection);
        this.fView.add(connection);
    }

    protected void loadCommentFigure(CommentTextFigure figure, Element figureNode) {
        Element wraptextNode;
        Point position = this.parsePoint(figureNode.attributeValue("position"));
        figure.moveTo(position);
        Element contentNode = figureNode.element("Content");
        Font font = new Font(contentNode.attributeValue("type"), (int)Integer.valueOf(contentNode.attributeValue("style")), Integer.valueOf(contentNode.attributeValue("size")));
        figure.setFont(font);
        figure.setAttribute("TextColor", new Color(Integer.valueOf(contentNode.attributeValue("color"))));
        String comment = contentNode.getText();
        figure.setText(comment);
        if (figureNode.attributeValue("opcode") != null) {
            BlockFigure observor = this.getBlockFigure(this.fWD.getBlock(Integer.valueOf(figureNode.attributeValue("opcode")), Integer.valueOf(figureNode.attributeValue("blockNumber"))));
            CommentParameter commentParameter = ((LogoDrawing)this.fView.drawing()).getCommentManager().getCommentParameter(observor.getBlock());
            if (Boolean.valueOf(figureNode.attributeValue("isBlockComment")).booleanValue()) {
                commentParameter.setText(comment);
                observor.setCommentFigure(figure);
                figure.setCommentParameter(commentParameter);
            }
            figure.connect(observor);
        }
        if ((wraptextNode = figureNode.element("WrapText")) != null) {
            figure.setWrapTextDimension(Integer.valueOf(wraptextNode.attributeValue("width")), Integer.valueOf(wraptextNode.attributeValue("height")));
            figure.setWrapText(true);
        }
    }

    protected void loadCuttedFigure(Element figureNode) {
        boolean start = !figureNode.attributeValue("direction").equals("1");
        CutConnectFigure figure = this.getCuttedConnFigure(start, figureNode.attributeValue("identifier"));
        CutConnectFigure partner = this.getCuttedConnFigure(!start, figureNode.attributeValue("partner"));
        figure.setPartner(partner);
        Point point = this.parsePoint(figureNode.attributeValue("position"));
        figure.moveTo(point);
    }

    protected void setDescription() {
        for (Figure figure : ((LogoDrawing)this.fView.drawing()).getFigures()) {
            if (!(figure instanceof CutConnectFigure)) continue;
            ((CutConnectFigure)figure).setDescription((LogoDrawing)this.fView.drawing());
        }
    }

    protected PageFormat loadPageFormat(Element propertiesNode) {
        Element paperformatNode = propertiesNode.element("PageFormat");
        Element marginNode = paperformatNode.element("Margin");
        double paperMarginX = Double.valueOf(marginNode.element("Left").getText());
        double paperMarginY = Double.valueOf(marginNode.element("Top").getText());
        Element paperImageNode = paperformatNode.element("Imagesize");
        double paperImageWidth = Double.valueOf(paperImageNode.element("Width").getText());
        double paperImageHeight = Double.valueOf(paperImageNode.element("Height").getText());
        Element paperNode = paperformatNode.element("Paper");
        double paperWidth = Double.valueOf(paperNode.element("Width").getText());
        double paperHeight = Double.valueOf(paperNode.element("Height").getText());
        int pageOrientation = Integer.valueOf(paperformatNode.element("Orientation").getText());
        Paper paper = new Paper();
        paper.setImageableArea(paperMarginX, paperMarginY, paperImageWidth, paperImageHeight);
        paper.setSize(paperWidth, paperHeight);
        PageFormat pageFormat = new PageFormat();
        pageFormat.setOrientation(pageOrientation);
        pageFormat.setPaper(paper);
        return pageFormat;
    }
}

